using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using Phidgets;
using Phidgets.Events;

namespace Phidget_Manager
{
    public partial class Form1 : Form
    {
        Phidgets.Manager manager;
        ArrayList rows;
        public Form1()
        {
            InitializeComponent();
        }

        void manager_Detach(object sender, DetachEventArgs e)
        {
            if (InvokeRequired)
                Invoke(new DetachEventHandler(manager_Detach),
                            new object[] { sender, e });
            else
            {
                textBox1.Text = textBox1.Text + "Detach: Serial: " + e.Device.SerialNumber +
                    " Name: " + e.Device.Name + " Tag: " + e.Device.Label + 
                    " Type: " + e.Device.Type + " Version: " + e.Device.Version + "\r\n";
            }
        }

        void manager_Attach(object sender, AttachEventArgs e)
        {
            if (InvokeRequired)
                Invoke(new AttachEventHandler(manager_Attach),
                            new object[] { sender, e });
            else
            {
                textBox1.Text = textBox1.Text + "Attach: Serial: " + e.Device.SerialNumber +
                    " Name: " + e.Device.Name + " Tag: " + e.Device.Label +
                    " Type: " + e.Device.Type + " Version: " + e.Device.Version + "\r\n";
            }
        }

        private void Form1_Load_1(object sender, EventArgs e)
        {
            rows = new ArrayList();
            manager = new Phidgets.Manager();
            manager.Attach += new AttachEventHandler(manager_Attach);
            manager.Detach += new DetachEventHandler(manager_Detach);
            manager.open();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }
    }
}